<?php
require __DIR__ . '/../config.php';

// Fungsi untuk melakukan request cURL
function curlRequest($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return ['success' => false, 'error' => $error];
    }
    
    if ($httpCode !== 200) {
        return ['success' => false, 'error' => "HTTP Error: $httpCode"];
    }
    
    return json_decode($response, true);
}

// Cek status IP
$statusText = '';
$expiredDate = '';
$daysLeft = 0;
$isActive = false;

// Proses pengecekan IP
$ipStatusUrl = $apiurl . '/lic/cekip.php?ip=' . urlencode($ip);
$ipStatus = curlRequest($ipStatusUrl);

if ($ipStatus && isset($ipStatus['success']) && $ipStatus['success']) {
    if (isset($ipStatus['active']) && $ipStatus['active']) {
        $isActive = true;
        $expiredDate = $ipStatus['data']['expired'];
        
        // Hitung hari tersisa
        $now = new DateTime('now', new DateTimeZone('Asia/Jakarta'));
        $expDate = new DateTime($expiredDate, new DateTimeZone('Asia/Jakarta'));
        $interval = $now->diff($expDate);
        $daysLeft = $interval->days;
        
        if ($now < $expDate) {
            $statusText = "Status IP aktif, expired dalam {$daysLeft} hari";
        } else {
            $statusText = "Status IP sudah expired";
            $isActive = false;
        }
    } else {
        $reason = $ipStatus['reason'] ?? 'unknown';
        if ($reason === 'not_registered') {
            $statusText = "Status IP belum terdaftar";
        } else {
            $statusText = "Status IP sudah expired";
            $expiredDate = $ipStatus['expired'] ?? '';
        }
    }
} else {
    $errorMsg = isset($ipStatus['error']) ? $ipStatus['error'] : 'Tidak dapat memeriksa status IP';
    $statusText = "Error: " . $errorMsg;
}

// Proses submit form
$result = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputPass = $_POST['password'] ?? '';
    
    if ($inputPass !== $pass) {
        $result = ['status' => 'error', 'msg' => 'Password salah'];
    } else {
        // Panggil API untuk mengeksekusi delete-packageall menggunakan cURL
        $deletePackageUrl = $apiurl . '/api/delete-packageall/index.php?ip='.urlencode($ip).'&user='.urlencode($user).'&pass='.urlencode($pass);
        $response = curlRequest($deletePackageUrl);
        
        if (isset($response['error'])) {
            $result = ['status' => 'error', 'msg' => 'Gagal terhubung ke server: ' . $response['error']];
        } else {
            $result = $response;
            
            if (!is_array($result)) {
                $result = ['status' => 'error', 'msg' => 'Respon tidak valid dari server'];
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id" class="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <link rel="icon" href="https://idpridehost.net/images/logo_dark.png">
    <link rel="shortcut icon" href="https://idpridehost.net/images/logo_dark.png">
    <link rel="apple-touch-icon" href="https://idpridehost.net/images/logo_dark.png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#baedfd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        },
                        dark: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-out',
                        'slide-in': 'slideIn 0.5s ease-out',
                        'pulse-soft': 'pulseSoft 2s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideIn: {
                            '0%': { transform: 'translateY(10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        pulseSoft: {
                            '0%, 100%': { opacity: '1' },
                            '50%': { opacity: '0.8' },
                        }
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .glass-effect {
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            background: rgba(255, 255, 255, 0.15);
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        .dark .glass-effect {
            background: rgba(15, 23, 42, 0.7);
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.25);
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #0369a1 100%);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #0384c7 0%, #075985 100%);
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(59, 130, 246, 0.4);
        }
        
        .menu-transition {
            transition: transform 0.3s ease;
        }
        
        .loading-spinner {
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .floating-element {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .gradient-border {
            position: relative;
            border: double 2px transparent;
            background-image: linear-gradient(white, white), 
                              linear-gradient(135deg, #0ea5e9 0%, #0369a1 100%);
            background-origin: border-box;
            background-clip: content-box, border-box;
        }
        
        .dark .gradient-border {
            background-image: linear-gradient(#1e293b, #1e293b), 
                              linear-gradient(135deg, #0ea5e9 0%, #0369a1 100%);
        }
        
        .status-indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 8px;
        }
        
        .status-active {
            background-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.3);
        }
        
        .status-inactive {
            background-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.3);
        }
        
        /* Sidebar styles */
        .sidebar {
            width: 260px;
            transform: translateX(-100%);
            transition: transform 0.3s ease;
            z-index: 40;
        }
        
        .sidebar-open .sidebar {
            transform: translateX(0);
        }
        
        .sidebar-overlay {
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s;
        }
        
        .sidebar-open .sidebar-overlay {
            opacity: 1;
            visibility: visible;
        }
        
        @media (min-width: 1024px) {
            .sidebar {
                transform: translateX(0);
                position: static;
                height: auto;
            }
            
            .main-content {
                margin-left: 260px;
                width: calc(100% - 260px);
            }
            
            .sidebar-toggle {
                display: none;
            }
            
            .sidebar-overlay {
                display: none;
            }
        }
        
        .sidebar-item {
            transition: all 0.2s ease;
        }
        
        .sidebar-item:hover {
            background-color: rgba(14, 165, 233, 0.1);
        }
        
        .sidebar-item.active {
            background-color: rgba(14, 165, 233, 0.2);
            border-right: 3px solid #0ea5e9;
        }
    </style>
</head>
<body class="min-h-screen bg-gradient-to-br from-primary-50 to-primary-100 dark:from-dark-900 dark:to-dark-800 text-gray-800 dark:text-gray-200 transition-colors duration-300">
    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay fixed inset-0 bg-black bg-opacity-50 z-30 lg:hidden" id="sidebar-overlay"></div>
    
    <!-- Sidebar -->
    <aside class="sidebar fixed top-0 left-0 h-full bg-white dark:bg-dark-800 shadow-xl z-40 overflow-y-auto">
        <div class="p-5 border-b border-gray-200 dark:border-gray-700 flex justify-between items-center">
            <div class="flex items-center space-x-2">
                <div class="w-10 h-10 rounded-lg bg-primary-600 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01" />
                    </svg>
                </div>
                <h1 class="text-xl font-bold text-primary-800 dark:text-white"><?php echo $brandname; ?></h1>
            </div>
            <button class="sidebar-close lg:hidden text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
        
        <div class="p-5 overflow-y-auto h-full pb-24">
            <ul class="space-y-2">
                <li>
                    <a href="../" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 hover:bg-primary-50 dark:hover:bg-dark-700 transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A9 9 0 1118.879 17.804M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                            <span>Addpackage</span>
                        </div>
                    </a>
                </li>

                <li>
                    <a href="../addpackage-root" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 font-medium transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                            </svg>
                            <span>Add Package Root</span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="../delete-allpackage" class="sidebar-item active block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 hover:bg-primary-50 dark:hover:bg-dark-700 transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                            </svg>
                            <span>Delete Package All</span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="../pasang-smtp" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 font-medium transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                            </svg>
                            <span>Pasang SMTP</span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="../install-litespeed" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 font-medium transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                            </svg>
                            <span>Install LiteSpeed</span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="../install-whmreseller" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 font-medium transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-1a2 2 0 100 4h1a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-1a2 2 0 10-4 0v1a1 1 0 01-1 1H7a1 1 0 01-1-1v-3a1 1 0 00-1-1H4a2 2 0 110-4h1a1 1 0 001-1V7a1 1 0 011-1h3a1 1 0 001-1V4z" />
                            </svg>
                            <span>Install WHMReseller</span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="https://api.idpridehost.net/reg" class="sidebar-item block py-2 px-4 rounded-lg text-gray-700 dark:text-gray-300 hover:bg-primary-50 dark:hover:bg-dark-700 transition-colors">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                            <span>Register</span>
                        </div>
                    </a>
                </li>
            </ul>
        </div>
    </aside>
    
    <!-- Main Content Wrapper -->
    <div class="main-content min-h-screen flex flex-col">
        <!-- Navigation -->
        <nav class="glass-effect sticky top-0 z-20">
            <div class="container mx-auto px-4 py-3 flex justify-between items-center">
                <div class="flex items-center space-x-2">
                    <button class="sidebar-toggle p-2 rounded-lg bg-white dark:bg-dark-700 shadow-sm hover:shadow-md transition-shadow lg:hidden">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div class="w-10 h-10 rounded-lg bg-primary-600 flex items-center justify-center lg:hidden">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01" />
                        </svg>
                    </div>
                    <h1 class="text-xl font-bold text-primary-800 dark:text-white lg:hidden"><?php echo $brandname; ?></h1>
                </div>
                
                <div class="flex items-center space-x-4">
                    <!-- Theme Toggle -->
                    <button id="theme-toggle" class="p-2 rounded-lg bg-white dark:bg-dark-700 shadow-sm hover:shadow-md transition-shadow">
                        <svg id="theme-icon-light" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-yellow-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <svg id="theme-icon-dark" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-indigo-400 hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="container mx-auto px-4 py-8 flex-1">
            <div class="max-w-4xl mx-auto">
                <!-- Header Section -->
                <div class="text-center mb-10 animate-fade-in">
                    <h2 class="text-3xl md:text-4xl font-bold text-primary-800 dark:text-white mb-4">Delete All Packages cPanel/WHM</h2>
                    <p class="text-lg text-primary-600 dark:text-primary-300">Hapus semua paket hosting dari server WHM Anda (kecuali paket default)</p>
                </div>
                
                <!-- Status Card -->
                <div class="bg-white dark:bg-dark-700 rounded-xl shadow-lg p-6 mb-8 card-hover animate-slide-in">
                    <div class="flex items-center justify-between flex-wrap gap-4">
                        <div class="flex items-center">
                            <span class="status-indicator <?php echo $isActive ? 'status-active' : 'status-inactive'; ?>"></span>
                            <div>
                                <h3 class="font-semibold">Status Server</h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo $ip; ?></p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="font-medium <?php echo $isActive ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'; ?>">
                                <?php echo $statusText; ?>
                            </p>
                            <?php if ($expiredDate): ?>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Expired: <?php echo $expiredDate; ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Warning Card -->
                <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-xl p-6 mb-8 card-hover animate-slide-in">
                    <div class="flex items-start">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-yellow-500 mt-0.5 mr-3 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                        <div>
                            <h3 class="font-semibold text-yellow-800 dark:text-yellow-200">Peringatan!</h3>
                            <p class="text-yellow-700 dark:text-yellow-300 text-sm mt-1">
                                Tindakan ini akan menghapus SEMUA paket dari server WHM Anda (kecuali paket default). 
                                Pastikan Anda telah membackup data penting sebelum melanjutkan. Tindakan ini tidak dapat dibatalkan.
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Main Card -->
                <div class="bg-white dark:bg-dark-700 rounded-xl shadow-lg overflow-hidden card-hover animate-slide-in">
                    <div class="p-1 bg-gradient-to-r from-primary-500 to-primary-700"></div>
                    
                    <div class="p-6 md:p-8">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 rounded-full bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center mr-4">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-primary-600 dark:text-primary-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white">Delete All Packages</h3>
                                <p class="text-gray-600 dark:text-gray-300">Masukkan password WHM untuk mengeksekusi penghapusan semua paket</p>
                            </div>
                        </div>
                        
                        <?php if (!$isActive): ?>
                        <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4 mb-6 flex items-start">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-500 mt-0.5 mr-3 flex-shrink-0" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <h4 class="font-medium text-red-800 dark:text-red-200">IP Tidak Aktif</h4>
                                <p class="text-red-700 dark:text-red-300 text-sm mt-1"><?php echo $statusText; ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <form id="deletePackageForm" method="POST" class="space-y-6">
                            <div>
                                <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Password WHM</label>
                                <div class="relative">
                                    <input 
                                        type="password" 
                                        id="password" 
                                        name="password" 
                                        placeholder="Masukkan password WHM" 
                                        class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent dark:focus:ring-primary-400 bg-white dark:bg-dark-600 text-gray-900 dark:text-white transition-colors"
                                        <?php echo !$isActive ? 'disabled' : ''; ?>
                                        required
                                    >
                                    <button type="button" id="togglePassword" class="absolute right-3 top-3.5 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                            
                            <button 
                                type="submit"
                                id="submitButton"
                                class="w-full py-3 px-4 bg-red-600 hover:bg-red-700 text-white font-semibold rounded-lg shadow-md transition-all duration-300 ease-in-out flex items-center justify-center <?php echo $isActive ? '' : 'opacity-50 cursor-not-allowed'; ?>"
                                <?php echo !$isActive ? 'disabled' : ''; ?>
                                onclick="return confirm('Apakah Anda yakin ingin menghapus SEMUA paket? Tindakan ini tidak dapat dibatalkan!');"
                            >
                                <span>Hapus Semua Paket</span>
                                <svg id="loading-icon" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-2 hidden animate-spin" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                </svg>
                            </button>
                        </form>
                        
                        <?php if ($result): ?>
                        <div class="mt-6 p-4 rounded-lg <?php echo $result['status'] === 'success' ? 'bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800' : 'bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800'; ?> animate-fade-in">
                            <div class="flex items-start">
                                <?php if ($result['status'] === 'success'): ?>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-green-500 mt-0.5 mr-3 flex-shrink-0" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                </svg>
                                <div>
                                    <h4 class="font-medium text-green-800 dark:text-green-200">Berhasil</h4>
                                    <p class="text-green-700 dark:text-green-300 text-sm mt-1">
                                        <?php echo $result['msg'] ?? 'Paket berhasil dihapus'; ?>
                                    </p>
                                    <?php if (isset($result['deleted']) && is_array($result['deleted'])): ?>
                                    <p class="text-green-700 dark:text-green-300 text-sm mt-2">
                                        Dihapus: <?php echo count($result['deleted']); ?> paket
                                    </p>
                                    <?php endif; ?>
                                    <?php if (isset($result['failed']) && is_array($result['failed']) && count($result['failed']) > 0): ?>
                                    <p class="text-yellow-700 dark:text-yellow-300 text-sm mt-1">
                                        Gagal: <?php echo count($result['failed']); ?> paket
                                    </p>
                                    <?php endif; ?>
                                    <?php if (isset($result['skipped'])): ?>
                                    <p class="text-blue-700 dark:text-blue-300 text-sm mt-1">
                                        Dilewati: <?php echo $result['skipped']; ?> paket (default)
                                    </p>
                                    <?php endif; ?>
                                </div>
                                <?php else: ?>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-500 mt-0.5 mr-3 flex-shrink-0" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                </svg>
                                <div>
                                    <h4 class="font-medium text-red-800 dark:text-red-200">Error</h4>
                                    <p class="text-red-700 dark:text-red-300 text-sm mt-1">
                                        <?php echo $result['msg']; ?>
                                    </p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Info Cards -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
                    <div class="bg-white dark:bg-dark-700 rounded-xl shadow-md p-5 card-hover animate-slide-in">
                        <div class="w-10 h-10 rounded-lg bg-blue-100 dark:bg-blue-900/30 flex items-center justify-center mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600 dark:text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h3 class="font-semibold text-gray-800 dark:text-white mb-2">Hati-hati</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Tindakan ini akan menghapus semua paket dari server. Pastikan Anda telah membackup data penting.</p>
                    </div>
                    
                    <div class="bg-white dark:bg-dark-700 rounded-xl shadow-md p-5 card-hover animate-slide-in">
                        <div class="w-10 h-10 rounded-lg bg-green-100 dark:bg-green-900/30 flex items-center justify-center mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <h3 class="font-semibold text-gray-800 dark:text-white mb-2">Paket Default</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Paket default tidak akan dihapus. Hanya paket custom yang akan dihapus dari sistem.</p>
                    </div>
                    
                    <div class="bg-white dark:bg-dark-700 rounded-xl shadow-md p-5 card-hover animate-slide-in">
                        <div class="w-10 h-10 rounded-lg bg-purple-100 dark:bg-purple-900/30 flex items-center justify-center mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-600 dark:text-purple-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z" />
                            </svg>
                        </div>
                        <h3 class="font-semibold text-gray-800 dark:text-white mb-2">Dukungan Cloud</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Didukung oleh infrastruktur cloud yang andal dan terpercaya untuk kinerja optimal.</p>
                    </div>
                </div>
            </div>
        </main>
        
        <!-- Footer -->
        <footer class="bg-white dark:bg-dark-800 border-t border-gray-200 dark:border-gray-700 mt-12 py-8">
            <div class="container mx-auto px-4">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="flex items-center mb-4 md:mb-0">
                        <div class="w-8 h-8 rounded-md bg-primary-600 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01" />
                            </svg>
                        </div>
                        <span class="text-lg font-semibold text-primary-800 dark:text-white"><?php echo $brandname; ?></span>
                    </div>
                    
                    <div class="flex items-center">
                        <span class="text-sm text-gray-600 dark:text-gray-400 mr-4">Status IP:</span>
                        <span class="text-sm font-medium <?php echo $isActive ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'; ?>">
                            <?php echo htmlspecialchars($statusText); ?>
                        </span>
                    </div>
                </div>
                
                <div class="mt-6 pt-6 border-t border-gray-100 dark:border-gray-700 text-center">
                    <p class="text-sm text-gray-500 dark:text-gray-500">© 2025 <?php echo $brandname; ?>. All rights reserved.</p>
                </div>
            </div>
        </footer>
    </div>

    <script>
        // Theme Toggle
        const themeToggle = document.getElementById('theme-toggle');
        const themeIconLight = document.getElementById('theme-icon-light');
        const themeIconDark = document.getElementById('theme-icon-dark');
        const htmlElement = document.documentElement;

        // Check for saved theme preference or use OS preference
        if (localStorage.getItem('theme') === 'dark' || 
            (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            htmlElement.classList.add('dark');
            themeIconLight.classList.add('hidden');
            themeIconDark.classList.remove('hidden');
        } else {
            htmlElement.classList.remove('dark');
            themeIconLight.classList.remove('hidden');
            themeIconDark.classList.add('hidden');
        }

        // Toggle theme
        themeToggle.addEventListener('click', () => {
            if (htmlElement.classList.contains('dark')) {
                htmlElement.classList.remove('dark');
                localStorage.setItem('theme', 'light');
                themeIconLight.classList.remove('hidden');
                themeIconDark.classList.add('hidden');
            } else {
                htmlElement.classList.add('dark');
                localStorage.setItem('theme', 'dark');
                themeIconLight.classList.add('hidden');
                themeIconDark.classList.remove('hidden');
            }
        });

        // Sidebar Toggle
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        const sidebarClose = document.querySelector('.sidebar-close');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const body = document.body;

        sidebarToggle.addEventListener('click', () => {
            body.classList.add('sidebar-open');
        });

        sidebarClose.addEventListener('click', () => {
            body.classList.remove('sidebar-open');
        });

        sidebarOverlay.addEventListener('click', () => {
            body.classList.remove('sidebar-open');
        });

        // Toggle Password Visibility
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');

        togglePassword.addEventListener('click', () => {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            // Toggle icon
            if (type === 'text') {
                togglePassword.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                    </svg>
                `;
            } else {
                togglePassword.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin='round' stroke-width='2' d='M15 12a3 3 0 11-6 0 3 3 0 016 0z' />
                        <path stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z' />
                    </svg>
                `;
            }
        });

        // Form Submission
        const deletePackageForm = document.getElementById('deletePackageForm');
        const submitButton = document.getElementById('submitButton');
        const loadingIcon = document.getElementById('loading-icon');

        deletePackageForm.addEventListener('submit', (e) => {
            e.preventDefault();
            
            const formData = new FormData(deletePackageForm);
            const password = formData.get('password');
            
            if (!password) {
                showNotification('Password tidak boleh kosong', 'error');
                return;
            }
            
            // Show loading state
            submitButton.disabled = true;
            loadingIcon.classList.remove('hidden');
            
            // Submit form
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                // Create a temporary element to parse the HTML response
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                
                // Hide loading state
                submitButton.disabled = false;
                loadingIcon.classList.add('hidden');
                
                // Check if there's a result message in the response
                const resultDiv = doc.querySelector('.bg-green-50, .bg-red-50');
                if (resultDiv) {
                    // Remove any existing result messages
                    const existingResult = document.querySelector('.bg-green-50, .bg-red-50');
                    if (existingResult) {
                        existingResult.remove();
                    }
                    
                    // Add the new result message to the form
                    deletePackageForm.after(resultDiv.cloneNode(true));
                    
                    // Scroll to the result message
                    resultDiv.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                submitButton.disabled = false;
                loadingIcon.classList.add('hidden');
                showNotification('Terjadi kesalahan saat mengirim permintaan', 'error');
            });
        });

        // Helper function to show notification
        function showNotification(message, type = 'success') {
            // Create notification element
            const notification = document.createElement('div');
            notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg transform transition-transform duration-300 translate-y-[-100px] ${
                type === 'success' ? 'bg-green-100 border border-green-200 text-green-800' : 'bg-red-100 border border-red-200 text-red-800'
            } dark:${type === 'success' ? 'bg-green-900/20 border-green-800 text-green-300' : 'bg-red-900/20 border-red-800 text-red-300'}`;
            
            notification.innerHTML = `
                <div class="flex items-center">
                    ${type === 'success' ? 
                        '<svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" /></svg>' :
                        '<svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" /></svg>'
                    }
                    <span>${message}</span>
                </div>
            `;
            
            document.body.appendChild(notification);
            
            // Animate in
            setTimeout(() => {
                notification.classList.remove('translate-y-[-100px]');
            }, 10);
            
            // Animate out and remove after 3 seconds
            setTimeout(() => {
                notification.classList.add('translate-y-[-100px]');
                setTimeout(() => {
                    notification.remove();
                }, 300);
            }, 3000);
        }
    </script>
</body>
</html>